/******************************************************************************/
class SetVec : BaseEvent
{
public:
            SetVec();
   virtual ~SetVec();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   // Variable to set
   UID m_VecUID;
   VarVec* m_VarVec;
   
   // Set from variables
   UID m_XVarFloatUID, m_YVarFloatUID, m_ZVarFloatUID;
   VarFloat* m_XVarFloat, *m_YVarFloat, *m_ZVarFloat;
   
   ENUM_FLOAT_OPERATIONS m_FloatOperation;
};
/******************************************************************************/
SetVec::SetVec() : BaseEvent(), m_VarVec(null), m_XVarFloat(null), m_YVarFloat(null), m_ZVarFloat(null)             
{
   
}
SetVec::~SetVec()
{
   
}
/******************************************************************************/
void SetVec::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("FloatOperation")) m_FloatOperation = (ENUM_FLOAT_OPERATIONS )p.asEnum();
   if(Param *p = obj.findParam("VarVecUID"))      m_VecUID         = p.asID();
   if(Param *p = obj.findParam("XVarFloatUID"))   m_XVarFloatUID   = p.asID();
   if(Param *p = obj.findParam("YVarFloatUID"))   m_YVarFloatUID   = p.asID();
   if(Param *p = obj.findParam("ZVarFloatUID"))   m_ZVarFloatUID   = p.asID();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SetVec::AfterCreate()
{
   // Find the correct VarInt to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesVec)
      if(variablesVec[i].id() == m_VecUID)
         m_VarVec = &variablesVec[i]; 
         
   DEBUG_ASSERT(m_VarVec, "VarVec not found in scene");
         
   REPA(variablesFloat)
   {
      if(variablesFloat[i].id() == m_XVarFloatUID)
         m_XVarFloat = &variablesFloat[i];
         
      if(variablesFloat[i].id() == m_YVarFloatUID)
         m_YVarFloat = &variablesFloat[i];
         
      if(variablesFloat[i].id() == m_ZVarFloatUID)
         m_ZVarFloat = &variablesFloat[i];
   }
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SetVec::CallTriggeredAction()
{
   if(m_XVarFloatUID != UIDZero)
   {
      if(m_FloatOperation == FLOAT_SET_VALUE)
         m_VarVec->SetX(m_XVarFloat->GetValue());
      else m_VarVec->AddX(m_XVarFloat->GetValue());
   }
         
      
   if(m_YVarFloatUID != UIDZero)
   {
      if(m_FloatOperation == FLOAT_SET_VALUE)
         m_VarVec->SetY(m_YVarFloat->GetValue());
      else m_VarVec->AddY(m_YVarFloat->GetValue());
      
   }
      
   if(m_ZVarFloatUID != UIDZero)
   {
      if(m_FloatOperation == FLOAT_SET_VALUE)
         m_VarVec->SetZ(m_ZVarFloat->GetValue());
      else m_VarVec->AddZ(m_ZVarFloat->GetValue());
      
   }
      
      
   if(m_LogDetailed || m_LogOutput)
   {
      //LogN(S+"Start Trigger: Setting VarInt (INFO: " + m_EditorInfo + " ) to: " + value);
   }      
}

// This method is called when the duration of the event has been reached
void SetVec::StopTriggeredAction()
{

}
/******************************************************************************/